/**
 * \file: mspin_typedef.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin Typedef
 *
 * \component: MSPIN
 *
 * \author: Torsten Plate ICT-ADITG/SW2 tplate@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2013 ADIT Corporation
 *
 * \history
 * 0.1 TPlate Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_INTERNAL_H_
#define MSPIN_INTERNAL_H_

#include "mspin_appl_if_adapter.h"
#include "mspin_lm_adapter_typedef.h"
#include "mySPIN-Core.h"

#ifdef PROJECTBUILD_NISSAN_LCN2
#include <adit_typedef.h>
#else
#include <adit-system/adit_typedef.h>
#endif

#include <stdbool.h>
#include <semaphore.h>
#include <mqueue.h> //mqd_t
#include <pthread.h>
#include <openssl/ssl.h>    //SSL

#define MSPIN_IVI_CORE_PING_TIMEOUT 0 //use 0 to switch off

typedef enum
{
    MSPIN_CONNECTION_AOAP,       //!< MSPIN_CONNECTION_AOAP: AOAP connection via USB
    MSPIN_CONNECTION_IAP_DEVICE, //!< MSPIN_CONNECTION_IAP_DEVICE: iAP1/iAP2 device mode connection (USB or BT)
    MSPIN_CONNECTION_IAP_HOST,   //!< MSPIN_CONNECTION_IAP_HOST: iAP2 host mode connection (USB)
    MSPIN_CONNECTION_CLIENT_TCP, //!< MSPIN_CONNECTION__CLIENT_TCP: TCP/IP connection from HU->SP (IVI acts as client. Wi-Fi, Ethernet).
    MSPIN_CONNECTION_SERVER_TCP, //!< MSPIN_CONNECTION_SERVER_TCP: TCP/IP connection from SP->HU (IVI acts as server. Wi-Fi, Ethernet).
    MSPIN_CONNECTION_CLIENT_TLS, //!< MSPIN_CONNECTION_CLIENT_TLS: TLS secured connection over TCP/IP from HU->SP (IVI acts as client. Wi-Fi, Ethernet).
    MSPIN_CONNECTION_SERVER_TLS, //!< MSPIN_CONNECTION_SERVER_TLS: TLS secured connection over TCP/IP from SP->HU (IVI acts as server. Wi-Fi, Ethernet).
} mspin_connection_type_t;

/**
 * @struct mspin_connectionHandle_t
 *
 * Structure holding connection specific parameters. Connections can be AOAP, iAP2, TCP/IP (Client/Server),
 * TLS (Client/Server).
 * Created with 'mspin_conn_createHandle' and deleted with 'mspin_conn_releaseHandle'
 */
typedef struct
{
    S32 accessoryId; //only required for AOAP
    S32 deviceId;    //only required for AOAP
    S32 result;
    bool audioSupport;
    mspin_connection_type_t connectionType;
    char *pWriteDevice; //only required for iAP2
    char *pReadDevice; //only required for iAP2

    MSPIN_EAPSend eapSend_CB; //only required for device mode of iAP1/iAP2
    MSPIN_EAPRead eapReceive_CB; //only required for device mode of iAP1/iAP2
    void *eapContext;

    int port;         //TCP/IP client port
    int connectionID; //the socket for TCP/TLS connections. Can be used to find the corresponding connection in tcp_manager

    bool connectionError;
} mspin_connectionHandle_t;

typedef struct
{
    //Variables used also by LayerManager Adapter
    void* pCoreInstance; //the mySPIN Core instance

    //LayerManager variables
    sem_t LMCreatedLock;
    sem_t LMDeletionLock;
    sem_t LMDeletedLock;
    pthread_t LMCreatorThread;
    bool LMReady;
    mspin_layerManager_context_t *pLayerManagerContext; //used only internally by mySPIN Target Adapter
    pthread_mutex_t LMCtxMutex;  // use to protect pLayerManagerContext - avoid deletion when using

    U32 instanceId;

    mspin_connectionHandle_t *pConnectionHandle;

    bool hasEverBeenReady;
    bool isReady;
    bool isCanceled;
    bool isSuspended;
    bool issueFirstFrameRendered;
    bool discardCurrentFrame;           //discard the current frame from mspin_core_onFrameUpdateStart over mspin_core_onFrameRectUpdate till mspin_core_onFrameUpdateEnd
    bool appTransitionInProgress;
    bool frameTransmissionActive;
    S32 commCount;  // count up while someone is sending or receiving since that could
                    // take longer and the Core should not be delete meanwhile

    MSPIN_ERROR cancelReason;
    sem_t coreStartingLock;
    sem_t connectLock;

    Flag useRawOutput;
    PixelEndianess pixelEndianess;
    FrameCompression compressionFormat;

#if (MSPIN_IVI_CORE_VERSION >= 0x01010000UL) //Since IVI  Core 1.1
    U32 preferredCompression;
    U32 physicalWidth;
    U32 physicalHeight;
#endif // (MSPIN_IVI_CORE_VERSION >= 0x01010000UL)

#if (MSPIN_IVI_CORE_VERSION >= 0x01020000UL) //Since IVI Core 1.2
    MSPIN_CUSTOMDATA_KEYPROFILE keyProfile;
    bool customPTTKey;
#endif

    U32 pingTimeout;
    U32 capabilities;
    MSPIN_VOICESESSION_CONSTRAINT voiceSessionConstraint;
    MSPIN_VOICESESSION_SUPPORT voiceSessionSupport;

#if (MSPIN_IVI_CORE_VERSION >= 0x01020000UL) //Since IVI  Core 1.2
    MSPIN_LAUNCHER_STATE launcherState;
#endif //(MSPIN_IVI_CORE_VERSION >= 0x01020000UL)

    U8 initializationTimeout;

    char AccVendor[256];
    char AccModel[256];
    char AccDescription[256];
    char AccVersion[256];
    char AccUri[1024];
    char AccSerial[256];

    bool EAPSessionStarted;

    //Callback functions for the system outside the adapter layer
    void (*OnPhoneCallStatus)(void* context, bool isActive);
    void (*OnAppTransitionStatus)(void* context, bool isActive);
    void (*OnAppInactive)(void* context, bool isInactive);
    void (*OnBlockStatus)(void* context, bool isBlocked);
    void (*OnPTTAvailable)(void* context, bool pttAvailable);
    void (*OnInitiatePhoneCall)(void* context, char* numberString, char* displayString);
    void (*OnNavigateTo)(void* context, char* displayString, MSPIN_NAVIGATETOTYPE type,
            double longitude, double latitude, MSPIN_LocationStrings_t* locationDesciption);
    void (*OnCustomString)(void* context, MSPIN_PHONEMSGSTRTYPE type, MSPIN_STRINGENCODING encoding, char* data);
    void (*OnCustomInt)(void* context, MSPIN_PHONEMSGINTTYPE type, U16 legth, U8* data);
    void (*OnVoiceSessionRequest)(void* context, MSPIN_VOICESESSION_REQUESTTYPE type);
    void (*OnAudioRequest)(void* context, MSPIN_AUDIOCONTROL command, UInt32 requestID, MSPIN_AUDIOTYPE type);
    void (*OnError)(void* context, MSPIN_ERROR error);
    void (*OnLMInitializedCB)(void* context);
    void (*OnLMDeinitializedCB)(void* context);
    void (*OnFirstFrameRenderedCB)(void* context);
    void (*OnFrameTransmissionStatusChangeCB)(void* context, bool start);
    void (*OnVehicleDataRequest)(void* context, bool request, U8 length, U32* keyList);

#if (MSPIN_IVI_CORE_VERSION >= 0x01020000UL) //Since IVI  Core 1.2
    MSPIN_OnLauncherStateChange OnLauncherStateChangeCB;
    MSPIN_OnHomeButtonUsabilityChange OnHomeButtonUsabilityChangeCB;
    MSPIN_OnAppListChanged OnAppListChangedCB;
    MSPIN_OnAppIconResponse OnAppIconResponseCB;
    MSPIN_OnAppStartedResponse OnAppStartedResponseCB;
#endif //(MSPIN_IVI_CORE_VERSION >= 0x01020000UL)
    MSPIN_OnFrameUpdateRaw OnFrameUpdateRawCB;
    void* outsideContext;

} mspin_context_t;

typedef struct
{
    //general configuration
    unsigned int timeout;
    int udpPort;

    //message content
    BOOL tls;
    char manufacturer[64];
    char vendor[64];
    char model[64];
    char version[12];
    char *pBTName;
    int tcpPort;
} mspin_udp_MessageParameter_t;

#endif /* MSPIN_INTERNAL_H_ */
